@extends('layouts.master')
@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    @stop


@section('content')
        <!--body wrapper start-->
    <div class="wrapper">
           @include('partials.message')
           <div class="row">
               <div class="col-sm-12">
                   <section class="panel">
                       <header class="panel-heading">
                             {{ trans('ui.procedures.names') }}
                             <span class="tools pull-right">
                                <a href="javascript:;" class="fa fa-chevron-down"></a>
                             </span>
                       </header>
                       <div class="panel-body">
                           @if(Auth::user() -> can(['create-procedures']))
                               <a href="{{ url('tramite/create') }}" class="pull-right"><button class="btn btn-primary" type="button"><i class="fa fa-plus-circle"></i> {{ trans("ui.procedures.button_add") }}</button></a>
                           @endif
                           <table class="display table table-bordered table-striped" id="dynamic-table">
                               <thead>
                                    <tr>
                                        <th>{{ trans('ui.procedures.name') }}</th>
                                        <th>{{ trans('ui.procedures.prefix') }}</th>
                                        <th>{{ trans('ui.procedures.payOrder') }}</th>
                                        <th>{{ trans('ui.procedures.documents') }}</th>
                                        @if(Auth::user()->can(['update-procedures', 'delete-procedures']))
                                            <th>{{ trans('ui.procedures.operation_label') }}</th>
                                        @endif
                                    </tr>
                               </thead>
                               <tbody>
                               @foreach($tramites as $tramite)
                                   <tr>
                                       <td>{{ $tramite->nombre }}</td>
                                       <td>{{ $tramite->prefijo }}</td>
                                       <td>
                                           @if($tramite -> payOrder == 1)
                                           Si
                                           @else
                                           No
                                           @endif
                                      </td>
                                       <td><ul>
                                               @foreach($tramite->documentos as $document)
                                                   <li>
                                                       {{ $document->nombre }}
                                                   </li>
                                               @endforeach
                                           </ul></td>
                                       @if(Auth::user()->can(['update-procedures', 'delete-procedures']))
                                           <td>

                                                   @if(Auth::user()->can('update-procedures'))
                                                       <a href="{{ url('tramite/' . $tramite->id . '/edit') }}">
                                                           <i class="fa fa-refresh"></i>
                                                       </a>
                                                   @endif

                                                   @if(Auth::user()->can('delete-procedures'))
                                                       {!! Form::open(['url' => 'tramite/'. $tramite->id, 'method' => 'delete','style'=>'display:inline-block;']) !!}
                                                       <button class="delete-button" type="submit"><i class="fa fa-times-circle"></i></button>
                                                       {!! Form::close() !!}
                                                   @endif

                                           </td>
                                       @endif
                                   </tr>
                               @endforeach
                               </tbody>
                           </table>
                       </div>
                   </section>
               </div>
           </div>
    </div>
@stop

@section('script')
        <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    <script src="{{ asset('js/dynamic_table_init.js') }}"></script>
@stop
