@extends('layouts.master')
@section('content')
        <!--body wrapper start-->
<div class="wrapper">
    @include('partials.message')
    <div class="row">
        <div class="col-sm-12">
            <section class="panel">
                <header class="panel-heading">
                     Detalle de registro
                    <span class="tools pull-right">
                                <a href="javascript:;" class="fa fa-chevron-down"></a>
                             </span>
                </header>
                <div class="panel-body">
                    <a href = "{{URL::to('registro')}}" class = 'btn btn-danger pull-right'>Regresar</a>


                    <div class="col-sm-12" style="margin-top: 3em;">

                        <div class="row">
                            <div class="col-md-10 col-lg-offset-1">
                                <div class="panel" style="border: 1px solid rgba(0, 0, 0, 0.2)">
                                    <header class="panel-heading">
                                        {{ trans('ui.promotoria.info_title') }}
                                    </header>
                                    <div class="panel-body">

                                        <div class="col-sm-10 col-sm-offset-1">
                                            <table class="table ">
                                                <tbody>

                                                <tr>
                                                    <th>Trámite</th>
                                                    <td>{{ $registro -> tramite -> nombre  }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Agente</th>
                                                    <td><ul style="padding: 0;">
                                                            @foreach($registro->usuarios as $usuario)
                                                                <li>
                                                                    {{ $usuario-> firstname. ' '. $usuario -> lastname }}
                                                                </li>
                                                            @endforeach
                                                        </ul></td>
                                                </tr>
                                                <tr>
                                                    <th>Fecha de atención</th>
                                                    <td> {{ $registro -> date }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Tiempo de atención</th>
                                                    <td> {{ $registro -> service_time }}</td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-10 col-lg-offset-1">
                                <div class="panel" style="border: 1px solid rgba(0, 0, 0, 0.2)">
                                    <header class="panel-heading">
                                       Servicios
                                    </header>
                                    <div class="panel-body">

                                        <div class="col-sm-10 col-sm-offset-1">
                                            <table class="display table table-bordered table-striped" >
                                                <thead>
                                                <tr>
                                                    <th>Clave</th>
                                                    <th>
                                                        Póliza
                                                    </th>
                                                    <th>Servicio</th>
                                                    <th>Observaciones</th>
                                                </tr>
                                                </thead>
                                                <tbody>


                                                @foreach($registro->servicios() -> where('sucursal_id',$registro -> sucursal_id) -> get() as $servicio)
                                                   <tr>
                                                       <td>{{ $servicio -> clave }}</td>
                                                       <td>
                                                           {{ $servicio->policy_id }}
                                                       </td>
                                                       <td>{{ $servicio -> servicio }}</td>
                                                       <td> {{ $servicio -> observacion }}</td>
                                                   </tr>
                                                @endforeach

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@stop
