@extends('layouts.master')

@section('content')
    <div class="wrapper">
        @include('partials.message')
        @include('reasons.create')
        @include('reasons.edit')
        <div class="row">
            {!! Form::open(['method' => 'delete', 'action' => ['ReasonController@destroy',0], 'class' => 'hidden','id' => 'deleteReason', ]) !!}
            {!! Form::close() !!}
            <div class="col-sm-12">
                <div class="panel">
                    <div class="panel-heading">
                        Motivos
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-sm pull-right">
                            <a href="#create" class="btn btn-primary" data-toggle="modal" id="create">
                                <i class="fa fa-plus"></i> Agregar
                            </a>
                            <hr>
                        </div>
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <th>
                                    ID
                                </th>
                                <th>
                                    Nombre
                                </th>
                                <th>
                                    Acciones
                                </th>
                            </thead>
                            <tbody>
                                @foreach ($reasons as $reason)
                                    <tr>
                                        <td>
                                            {{ $reason->id }}
                                        </td>
                                        <td>
                                            {{ $reason->name }}
                                        </td>
                                        <td>
                                            <a href="#" data-toggle="tooltip" title="Editar" class="btn btn-primary btn-edit btn-xs" data-id="{{$reason->id}}">
                                                <i class="fa fa-pencil" aria-hidden="true"></i>
                                            </a>
                                            <a href="#" class="btn btn-danger btn-delete btn-xs" data-id="{{$reason->id}}" data-toggle="tooltip" title="Eliminar">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')
    <script type="text/javascript" src="{{asset('js/reasons.js')}}"></script>
@stop
