@extends('layouts.master')
@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    @stop


    @section('content')
    <div class="wrapper">
        @include('partials.message')
        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        {{ trans('ui.promotoria.names') }}
                        <span class="tools pull-right">
                                <a href="javascript:;" class="fa fa-chevron-down"></a>
                             </span>
                    </header>
                    <div class="panel-body">
                            <a href="{{ url('promotoria/create') }}" class="pull-right"><button class="btn btn-primary" type="button"><i class="fa fa-plus-circle"></i> {{ trans("ui.promotoria.button_add") }}</button></a>
                        <table class="display table table-bordered table-striped" id="dynamic-table">
                            <thead>
                            <tr>
                                <th>{{ trans('ui.promotoria.key') }}</th>
                                <th>{{ trans('ui.promotoria.business_name') }}</th>
                                <th>{{ trans('ui.documents.operation_label') }}</th>
                             </tr>
                            </thead>
                            <tbody>
                            @foreach($promotorias as $promotoria)
                                <tr>
                                    <td>{{ $promotoria -> clave }}</td>
                                    <td>{{ $promotoria->razonSocial }}</td>
                                        <td>
                                                <a href="{{ url('promotoria/' . $promotoria->id . '/edit') }}">
                                                    <i class="fa fa-refresh"></i>
                                                </a>

                                                <a href="{{ url('promotoria/' . $promotoria->id ) }}">
                                                     <i class="fa fa-eye"></i>
                                                </a>


                                            {!! Form::open(['url' => 'promotoria/'. $promotoria->id, 'method' => 'delete','style'=>'display:inline-block;']) !!}
                                                <button class="delete-button" type="submit"><i class="fa fa-times-circle"></i></button>
                                                {!! Form::close() !!}

                                        </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </div>
    @stop

    @section('script')
            <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    <script src="{{ asset('js/dynamic_table_init.js') }}"></script>
@stop
