@extends('layouts.master')
    @section('content')
            <!--body wrapper start-->
    <div class="wrapper">
        @include('partials.message')
        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        {{ trans('ui.promotoria.names') }}
                        <span class="tools pull-right">
                                <a href="javascript:;" class="fa fa-chevron-down"></a>
                             </span>
                    </header>
                    <div class="panel-body">
                        @if(Auth::user() -> can(['update-promotoria']))
                            @if(isset($promotoria))
                            <a href="{{ url('promotoria/' . $promotoria->id . '/edit') }}" class="pull-right"><button class="btn btn-primary" type="button"><i class="fa fa-plus-circle"></i> {{ trans("ui.promotoria.button_update") }}</button></a>
                            @else
                            <a href="{{ url('promotoria/create') }}" class="pull-right"><button class="btn btn-primary" type="button"><i class="fa fa-plus-circle"></i> {{ trans("ui.promotoria.button_update") }}</button></a>
                            @endif
                        @endif
                        <div class="col-sm-12" style="margin-top: 3em;">
                            <div class="row">
                                <div class="col-md-3 col-lg-offset-4">
                                    <div class="panel" style="border: 1px solid rgba(0, 0, 0, 0.2)">
                                        <div class="panel-body">
                                            <div class="porfile-pic text-center">
                                                <img class="img-responsive" src="{{ isset($promotoria)?asset('images/promotoria/'.$promotoria -> logo):'http://www.placehold.it/300x100/EFEFEF/AAAAAA&amp;text=no+imagen'  }}" alt="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                             </div>
                             <div class="row">
                                 <div class="col-md-7 col-lg-offset-2">
                                     <div class="panel" style="border: 1px solid rgba(0, 0, 0, 0.2)">
                                         <header class="panel-heading">
                                             {{ trans('ui.promotoria.info_title') }}
                                         </header>
                                         <div class="panel-body">
                                            <div class="col-sm-8 col-sm-offset-2">
                                                <table class="table ">
                                                    <tbody>
                                                    <tr>
                                                        <th>{{ trans('ui.promotoria.business_name') }}</th>
                                                        <td>{{ isset($promotoria)?$promotoria -> razonSocial:''  }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>{{trans('ui.promotoria.key')}}</th>
                                                        <td>{{ isset($promotoria)?$promotoria -> clave:''  }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>{{ trans('ui.promotoria.data_connection') }}</th>
                                                        <td>
                                                            @if(isset($promotoria))
                                                                @if($promotoria -> dbConnection === NULL||$promotoria -> username  === NULL|| $promotoria -> password === NULL || empty($promotoria -> dbConnection) || empty($promotoria -> username) || empty($promotoria -> password))
                                                                    <i class="fa fa-exclamation-circle" style="color:#d9534f;"></i>
                                                                @else
                                                                    <i class="fa fa-check-square" style="color:#5cb85c;"></i>
                                                                @endif
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    @stop

