<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="{{ asset('images/favicon.ico') }}">
    <title>{{ trans('ui.title') }}</title>

    {!! Html::style('css/bootstrap.min.css') !!}
    {!! Html::style('css/style.css') !!}
    {!! Html::style('css/style-responsive.css') !!}
</head>
<body class="login-body">

<div class="container">

    {!! Form::open(array('route' => 'auth.login', 'class' => 'cmxform form-signin', 'id' => 'loginForm')) !!}
    {!! csrf_field()!!}
    <div class="form-signin-heading text-center">
        <h3 style="font-weight: bold; color: #7a7676">TURNOS <span class="text-muted">PRO</span></h3>
    </div>
    <div class="login-wrap">
        <input type="text" class="form-control" name="email" placeholder={{ trans('ui.login.email') }} autofocus>

        <input type="password" class="form-control" name="password" placeholder={{ trans('ui.login.password') }}>

        <button class="btn btn-lg btn-login btn-block" type="submit">
            <i class="fa fa-check"></i>
        </button>

        <label class="checkbox">
            <input type="checkbox" value="remember-me" name="remember"> {{ trans('ui.login.rememberme') }}
            <a href="{{ url('password/email') }}" class="pull-right">¿Olvidaste tu contraseña?</a>
        </label>

        @include('errors.form_error')
    </div>
    {!! Form::close() !!}

</div>

@include('partials.script')
</body>
</html>
