<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="{{ asset('images/favicon.ico') }}">
    <title>{{ trans('ui.title') }}</title>

    {!! Html::style('css/bootstrap.min.css') !!}
    {!! Html::style('css/style.css') !!}
    {!! Html::style('css/style-responsive.css') !!}
</head>
<body class="login-body">

<div class="container">
    {!! Form::open(['method' => 'POST', 'url' => '/password/email', 'class' => 'cmxform form-signin']) !!}
        @if (session('status'))
            <div class="alert alert-success">
                {{ session('status') }}
            </div>
        @endif
        <div class="form-signin-heading text-center">
            <h3 style="font-weight: bold; color: #7a7676">TURNOS <span class="text-muted">PRO</span></h3>
            <h4 style="font-weight: bold; color: #7a7676">Ingresa tu email</h4>
        </div>
        <div class="login-wrap">
            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                {!! Form::email('email', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => 'email@ejemplo.com']) !!}
                <small class="text-danger">{{ $errors->first('email') }}</small>
            </div>
            {!! Form::submit('Enviar el enlace al email', ['class' => 'btn btn-primary btn-block']) !!}
            <label class="checkbox">
                <a href="{{ url('/') }}">Iniciar sesión</a>
            </label>
        </div>

    {!! Form::close() !!}
</div>

@include('partials.script')
</body>
</html>
