$(document).ready(function() {
    $("#userName" ).select2({
        language: 'es',
        allowClear: true,
        theme: "bootstrap",
        placeholder: {
            id: "",
            placeholder: "Seleccione una opción"
        },
        ajax: {
            url: '/auth/user',
            delay: 1000,
            processResults: function (data) {
                return {
                    results: data.users,
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        minimumInputLength: 3,
        templateResult: function (item) {
            if (item.placeholder) return item.placeholder;
            return formatState(item)
        },
        templateSelection: function (item) {
            if (item.placeholder) return item.placeholder;
            return formatState(item)
        },
    });

    $('div.alert').not('.alert-important').delay(3000).fadeOut(350);
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth();
    var year = d.getFullYear();
    $('#dtpInicio').datetimepicker({
        format: 'DD/MM/YYYY',
        locale: 'es',
        defaultDate: new Date(year, month - 1, day)
    });
    $('#dtpFin').datetimepicker({
        format: 'DD/MM/YYYY',
        locale: 'es',
        defaultDate: new Date(year, month, day)
    });
});

function formatState (state) {
    if (!state.id) {
        return state.text;
    }
    var $state = $(
        '<span>' +
        state.firstname + ' ' + state.lastname +
        '</span>'
    );
    return $state;
};

$(document).on('change', '#tipo', function(event) {
    event.preventDefault();
    if ($(this).val() == 'mes') {
        $('div.group-date').addClass('hidden');
        $('div.group-mont').removeClass('hidden');
    } else {
        $('div.group-mont').addClass('hidden');
        $('div.group-date').removeClass('hidden');
    }
});

$(document).on('change', '#sucursal', function(event) {
    event.preventDefault();
    if ($(this).val() == -1) {
        $('.group-filters').addClass('hidden');
    } else {
        $('.group-filters').removeClass('hidden');
    }
});

$(document).on('click', '#btnVerReporte', function(event) {
    $('#xportExcel').val(false);
});

$(document).on('click', '#btnExportXL', function(event) {
    $('#xportExcel').val(true);
});

$(document).on('submit', 'form#formDataReports', function(event) {
    if ($('#xportExcel').val() == 'true') {
        return true;
    } else {
        event.preventDefault();
        $('#btnVerReporte').addClass('hidden');
        $('#btnWaitReport').removeClass('hidden');
        $.ajax({
            url: $(this).prop('action'),
            type: 'POST',
            data: $(this).serialize()
        })
        .done(function(response) {
            $('#contentReports').html(response);
            $('#btnVerReporte').removeClass('hidden');
            $('#btnWaitReport').addClass('hidden');
            // console.log("success");
        })
        .fail(function() {
            console.log("error");
        });
    }
});

$(document).on('click', '.btn-rows-ids', function(event) {
    event.preventDefault();
    $('#reporteGralDetalle .modal-body .row').empty();
    $('#reporteGralDetalle .modal-body .text-center').show();
    var ids = $(this).data('id');
    $.ajax({
        url: 'reporte/123',
        data : {ids: ids, }
    })
    .done(function(response) {
        $('#reporteGralDetalle .modal-body .text-center').hide();
        $('#reporteGralDetalle .modal-body .row').html(response);
    })
    .fail(function() {
        console.log("error");
    })
    .always(function() {
        console.log("complete");
    });
});

$(document).on('click', '#btnImprimir', function(event) {
    event.preventDefault();
    PrintElem('#contentReports');
    // window.print();
});
function PrintElem(elem){
    Popup($(elem).html());
}

function Popup(data) {
    var mywindow = window.open('', 'my div', 'height=800,width=1200');
    mywindow.document.write('<html><head><title>Reporte de registros</title>');
    mywindow.document.write('<style type="text/css">table {width:100%;} table tbody td,table tbody th{ width:auto; padding: 10px; text-align:left} </style>');
    mywindow.document.write('</head><body>');
    mywindow.document.write(data);
    mywindow.document.write('</body></html>');
    mywindow.print();
    mywindow.close();
    return true;
}
