$(document).on('click', '.btn-primary.btn-edit', function(event) {
    event.preventDefault();
    var id = $(this).data('id');
    $.ajax({
        url: '/reasons/'+id+'/edit',
    })
    .done(function(response) {
        var reason = response.reason;
        $("div#edit.modal form").attr('action', '/reasons/'+reason.id);
        $("#edit form input[name='name']").val(reason.name);
        $('#edit').modal('show');
    })
    .fail(function() {
        console.log("error");
    });

});

$(document).on('click', '.btn-danger.btn-delete', function(event) {
    event.preventDefault();
    console.log($('form input[name="_token"]').val());
    var id = $(this).data('id');
    swal({
        title: '¿Estás seguro de eliminar el motivo?',
        text: "La acción no podrá deshacerse!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Eliminar!',
        showLoaderOnConfirm: true,
        preConfirm: function () {
            return new Promise(function (resolve, reject) {
                if (id > 0) {
                    $('form#deleteReason').attr('action', '/reasons/'+id);
                    $('form#deleteReason').submit();
                    resolve()
                } else {
                    reject()
                }
            })
        }
    }).then(function() {
        // swal('Ready')
        // $.ajax({
        //     url: '/reasons/'+id,
        //     headers: {
        //         'CSRF-TOKEN': $('form input[name="_token"]').val()
        //     },
        //     method: 'DELETE',
        // })
        // .done(function(response) {
        //     console.log(response);
        //     // var reason = response.reason;
        //     // $("div#edit.modal form").attr('action', '/reasons/'+reason.id);
        //     // $("#edit form input[name='name']").val(reason.name);
        //     // $('#edit').modal('show');
        // })
        // .fail(function() {
        //     console.log("error");
        // });
    }).done()
});
