<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRecordServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('servicios',function(Blueprint $table){
            $table->increments('id');
            $table->integer('record_id');
            $table->string('observacion');
            $table->string('servicio');
            $table->string('clave');
            $table->integer('promotoria_id') -> unsigned();
            $table->foreign('promotoria_id')->references('id')->on('promotorias')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
