<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddVentanillasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ventanillas',function(Blueprint $table){
            $table->increments('id');
            $table->string('nombre');
            $table->boolean('status')->default(true);
            $table->integer('sucursal_id')->unsigned();
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('sucursal_id')->references('id')->on('sucursales')
                ->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('ventanillas');
    }
}
