<?php

namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Zizaco\Entrust\Traits\EntrustUserTrait;

class User extends Model implements AuthenticatableContract, CanResetPasswordContract
{
    use Authenticatable, CanResetPassword;
    use EntrustUserTrait;


    protected $table = 'user';

    protected $fillable = ['firstname', 'lastname', 'username', 'email', 'password','promotoria_id','sucursal_id'];

    protected $hidden = ['password', 'remember_token'];

    public function getFullNameAttribute($value)
    {
        return $this->firstname ." ". $this->lastname;
    }

    public function roles() {

        return $this->belongsToMany('App\Role', 'role_user');
    }


    public function promotoria(){
        return $this -> belongsTo('App\Promotoria','promotoria_id','id');
    }
    public function tramites() {
        return $this->belongsToMany('App\Tramites', 'user_tramites','user_id', 'tramite_id');
    }
    public function sucursal(){
        return $this -> belongsTo('App\Sucursales','sucursal_id','id');
    }
}
