<?php

namespace App\Http\Controllers;

use App\Documentos;
use App\Tramites;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\TramiteRequest;


class TramitesController extends Controller
{
    public function __construct() {

        $this->middleware('auth');
    }

    public  function index(){
        if(Auth::user()->can('read-procedures')) {

            $tramites = Tramites::where('promotoria_id',Auth::user() -> promotoria_id) -> get();
            return view('tramites.index', compact('tramites'));
        }
        return redirect('auth/logout');

    }


    public function show($id){
        if(Auth::user()->can('read-procedures')) {


            $tramite = Tramites::find($id);
            return view('tramites.show', compact('tramite'));
        }
        return redirect('auth/logout');

    }

    public function create(){
            if(Auth::user()->can('create-procedures')) {
            $documentos = Documentos::where('promotoria_id',Auth::user() -> promotoria_id) -> orderBy('nombre', 'asc')->lists('nombre', 'id');
            return view('tramites.create', compact('documentos'));

        }
        return redirect('auth/logout');
    }

    public function store(TramiteRequest $request){
        if(Auth::user()->can('create-procedures')) {
            $isRegistro = ($request->is_registro) ? 1 : 0 ;
            $data = Tramites::create([
                    'nombre' =>  $request->input('nombre'),
                    'prefijo'  =>  $request->input('prefijo'),
                    'payOrder'  =>  $request->input('payOrder'),
                    'promotoria_id'   => Auth::user() -> promotoria_id,
                    'is_registro' => $isRegistro,
                    'password'  =>  \Hash::make($request->input('password')),
            ]
            );

            $tramite = Tramites::findOrFail($data->id);
            if($data -> payOrder == 0)
                   $data-> documentos() -> attach($request->input('documents_id'));

            Session::flash('message', trans('ui.procedures.message_create', array('name' => $tramite->nombre)));

            return redirect('tramite/create');
        }
        return redirect('auth/logout');
    }



    public function edit($id){
            if(Auth::user()->can('update-procedures')) {
            $tramite = Tramites::findOrFail($id);
            $tramite_documentos= Tramites::find($id)->documentos()->lists('documento_id')->toArray();
             $documentos = Documentos::where('promotoria_id',Auth::user() -> promotoria_id) -> orderBy('nombre', 'asc')->lists('nombre', 'id');
            return view('tramites.edit',compact('tramite','tramite_documentos','documentos'));

        }
        return redirect('auth/logout');
    }

    public function update($id, TramiteRequest $request){
            if(Auth::user()->can('update-procedures')) {
                $isRegistro = ($request->is_registro) ? 1 : 0 ;

            $tramite = Tramites::findOrFail($id);

            $tramite->update([
                'nombre' =>  $request->input('nombre'),
                'prefijo'  =>  $request->input('prefijo'),
                'payOrder'  =>  $request->input('payOrder'),
                'promotoria_id'   => Auth::user() -> promotoria_id,
                'is_registro' => $isRegistro,
                'password'  =>  \Hash::make($request->input('password')),
            ]);

            if($tramite->documentos->count()) {
                $tramite->documentos()->detach($tramite->documentos()->lists('documento_id')->toArray());
            }
                if($tramite -> payOrder == 0)
                    $tramite-> documentos() -> attach($request->input('documents_id'));
                else
                    $tramite->documentos()->detach($tramite->documentos()->lists('documento_id')->toArray());

                Session::flash('message', trans('ui.procedures.message_update', array('name' => $tramite->nombre)));

            return redirect('tramite');

        }
        return redirect('auth/logout');
    }

    public function destroy($id){
            if (Auth::user()->can('delete-procedures')) {
                $tramite = Tramites::findOrFail($id);
                Tramites::destroy($id);
                Session::flash('message', trans('ui.procedures.message_delete', array('name' => $tramite->nombre)));
                return redirect('tramite');
            }
            return redirect('auth/logout');
    }
}
