<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Requests\SucursalRequest;
use App\Sucursales;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Request;
use Response;
use DB;

class SucursalesController extends Controller
{
    public function __construct() {
        $this->middleware('auth');
    }

    public  function index(){
        if(Auth::user()->can('read-branches')) {

            $sucursales = Sucursales::where('promotoria_id',Auth::user() -> promotoria_id) -> get();
            return view('sucursales.index', compact('sucursales'));
        }
        return redirect('auth/logout');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (Request::ajax()) {
            $sucursal = Sucursales::findOrFail($id);
            if ($sucursal) {
                $servicios = DB::table('servicios')->select('id','servicio AS nombre')->where('sucursal_id',$sucursal->id)->groupBy('nombre')->get();
                return Response::json(['status' => 'OK', 'id' => $id, 'ventanillas' => $sucursal->ventanillas, ]);
            }
        } else {
            $sucursal = Sucursales::find($id);
            $registros = $sucursal->registros()->paginate(35);
            return view('registro.sucursal', ['sucursal' => $sucursal, 'registros' => $registros, ]);
        }
    }



    public function create(){
            if(Auth::user()->can('create-branches')) {
            $sucursales = Sucursales::orderBy('nombre', 'asc')->lists('nombre', 'id');
            return view('sucursales.create', compact('sucursales'));

        }

            return redirect('auth/logout');
    }

    public function store(SucursalRequest $request){
            if(Auth::user()->can('create-branches')) {

            $data = Sucursales::create($request->all());
            $sucursal = Sucursales::findOrFail($data->id);
            Session::flash('message', trans('ui.branches.message_create', array('name' => $sucursal->nombre)));
            return redirect('sucursal/create');
        }
        return redirect('auth/logout');
    }



    public function edit($id){
            if(Auth::user()->can('update-branches')) {
            $sucursal = sucursales::findOrFail($id);
            return view('sucursales.edit',compact('sucursal'));

        }
        return redirect('auth/logout');
    }

    public function update($id, SucursalRequest $request){
            if (Auth::user()->can('update-branches')) {

                $sucursal = sucursales::findOrFail($id);

                $sucursal->update($request->all());

                Session::flash('message', trans('ui.branches.message_update', array('name' => $sucursal->nombre)));

                return redirect('sucursal');

            }

            return redirect('auth/logout');
    }

    public function destroy($id){
            if(Auth::user()->can('delete-branches')) {
            $sucursal = sucursales::findOrFail($id);
            Sucursales::destroy($id);
            Session::flash('message', trans('ui.branches.message_delete', array('name' => $sucursal->nombre)));
            return redirect('sucursal');
        }
            return redirect('auth/logout');
     }
}
